% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.odds}
\alias{meta.lc.odds}
\title{Confidence interval for a log-linear contrast of odds ratios}
\usage{
meta.lc.odds(alpha, f1, f2, n1, n2, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimated log-linear contrast
\item SE - standard error of log-linear contrast
\item exp(Estimate) - exponentiated log-linear contrast
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
exponentiated log-linear contrast of odds ratios from two or more studies.
}
\examples{
n1 <- c(50, 150, 150)
f1 <- c(16, 50, 25)
n2 <- c(50, 150, 150)
f2 <- c(7, 15, 20)
v <- c(1, -1, 0)
meta.lc.odds(.05, f1, f2, n1, n2, v)

# Should return:
#            Estimate        SE  exp(Estimate)   exp(LL)  exp(UL)
# Contrast -0.4596883 0.5895438      0.6314805 0.1988563 2.005305


}
\references{
\insertRef{Bonett2015}{vcmeta}
}
