% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.mean1}
\alias{meta.lm.mean1}
\title{Meta-regression analysis for 1-group means}
\usage{
meta.lm.mean1(alpha, m, sd, n, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated means}

\item{sd}{vector of estimated standard deviations}

\item{n}{vector of sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item t - t-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a mean
from one group. The estimates are OLS estimates with robust
standard errors that accomodate residual heteroscedasticity.
}
\examples{
n <- c(25, 15, 30, 25, 40)
m <- c(20.1, 20.5, 19.3, 21.5, 19.4)
sd <- c(10.4, 10.2, 8.5, 10.3, 7.8)
x1 <- c(1, 1, 0, 0, 0)
x2 <- c( 12, 13, 11, 13, 15)
X <- matrix(cbind(x1, x2), 5, 2)
meta.lm.mean1(.05, m, sd, n, X)

# Should return: 
#       Estimate        SE          t     p         LL        UL  df
# b0 19.45490196 6.7873381 2.86635227 0.005  6.0288763 32.880928 132
# b1  0.25686275 1.9834765 0.12950128 0.897 -3.6666499  4.180375 132
# b2  0.04705882 0.5064693 0.09291544 0.926 -0.9547876  1.048905 132


}
