% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.meanratio.ps}
\alias{se.meanratio.ps}
\title{Computes the standard error for a paired-samples log mean ratio}
\usage{
se.meanratio.ps(m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{m1}{estimated mean for measurement 1}

\item{m2}{estimated mean for measurement 2}

\item{sd1}{estimated standard deviation for measurement 1}

\item{sd2}{estimated standard deviation for measurement 2}

\item{cor}{estimated correlation for measurements 1 and 2}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated log mean ratio
\item SE - standard error
}
}
\description{
This function computes the standard error of a
paired-samples log mean ratio using the estimated means, estimated
standard deviations, estimated Pearson correlation, and sample
size. The log-mean estimate and standard error output from
this function can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions in
applications where compatible mean ratios from a combination of 2-group
and paired-samples experiments are used in the meta-analysis.
Equality of variances is not assumed.
}
\examples{
se.meanratio.ps(21.9, 16.1, 3.82, 3.21, .748, 40)

# Should return:
#                   Estimate         SE
# Log mean ratio:  0.3076674 0.02130161


}
\references{
\insertRef{Bonett2020}{vcmeta}
}
