% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.pbcor}
\alias{se.pbcor}
\title{Computes the standard error for a point-biserial correlation}
\usage{
se.pbcor(m1, m2, sd1, sd2, n1, n2, type)
}
\arguments{
\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}

\item{type}{\itemize{
\item set to 1 for weighted variance average
\item set to 2 for unweighted variance average
}}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated point-biserial correlation
\item SE - standard error
}
}
\description{
This function computes a point-biserial correlation and its standard
error for two types of point-biserial correlations in 2-group designs
using the estimated means, estimated standard deviations, and samples
sizes. Equality of variances is not assumed. One type of point-biserial
correlation uses an unweighted average of variances and is recommended
for 2-group experimental designs. The other type of point-biserial
correlation uses a weighted average of variances and is recommended for
2-group nonexperimental designs with simple random sampling (but not
stratified random sampling). This function is useful in a meta-analysis
of compatible point-biserial correlations where some studies used a
2-group experimental design and other studies used a 2-group
nonexperimental design. The effect size estimate and standard error
output from this function can  be used as input in the
\link[vcmeta]{meta.ave.cor.gen} function.
}
\examples{
se.pbcor(21.9, 16.1, 3.82, 3.21, 40, 40, 1)

#  Should return: 
#                                Estimate         SE
#  Point-biserial correlation:  0.6349786 0.05981325


}
\references{
\insertRef{Bonett2020b}{vcmeta}
}
