% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http_interaction.R
\name{HTTPInteraction}
\alias{HTTPInteraction}
\title{HTTPInteraction class}
\description{
object holds request and response objects
}
\details{
\strong{Methods}
\describe{
\item{\code{to_hash()}}{
Create a hash from the HTTPInteraction object
}
\item{\code{from_hash(hash)}}{
Create a HTTPInteraction object from a hash
}
}
}
\examples{
\dontrun{
# make the request
library(vcr)
url <- "https://hb.opencpu.org/post"
body <- list(foo = "bar")
cli <- crul::HttpClient$new(url = url)
res <- cli$post(body = body)

# build a Request object
(request <- Request$new("POST", uri = url,
  body = body, headers = res$response_headers))
# build a VcrResponse object
(response <- VcrResponse$new(
   res$status_http(),
   res$response_headers,
   res$parse("UTF-8"),
   res$response_headers$status))

# make HTTPInteraction object
(x <- HTTPInteraction$new(request = request, response = response))
x$recorded_at
x$to_hash()

# make an HTTPInteraction from a hash with the object already made
x$from_hash(x$to_hash())

# Make an HTTPInteraction from a hash alone
my_hash <- x$to_hash()
HTTPInteraction$new()$from_hash(my_hash)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request}}{A \code{Request} class object}

\item{\code{response}}{A \code{VcrResponse} class object}

\item{\code{recorded_at}}{(character) Time http interaction recorded at}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HTTPInteraction-new}{\code{HTTPInteraction$new()}}
\item \href{#method-HTTPInteraction-to_hash}{\code{HTTPInteraction$to_hash()}}
\item \href{#method-HTTPInteraction-from_hash}{\code{HTTPInteraction$from_hash()}}
\item \href{#method-HTTPInteraction-clone}{\code{HTTPInteraction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPInteraction-new"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPInteraction-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HTTPInteraction} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPInteraction$new(request, response, recorded_at)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{A \code{Request} class object}

\item{\code{response}}{A \code{VcrResponse} class object}

\item{\code{recorded_at}}{(character) Time http interaction recorded at}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{HTTPInteraction} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPInteraction-to_hash"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPInteraction-to_hash}{}}}
\subsection{Method \code{to_hash()}}{
Create a hash from the HTTPInteraction object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPInteraction$to_hash()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPInteraction-from_hash"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPInteraction-from_hash}{}}}
\subsection{Method \code{from_hash()}}{
Create a HTTPInteraction object from a hash
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPInteraction$from_hash(hash)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{a named list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{HttpInteraction} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPInteraction-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPInteraction-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPInteraction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
