% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.R
\name{vec_c}
\alias{vec_c}
\title{Combine many vectors into one vector}
\usage{
vec_c(..., .ptype = NULL)
}
\arguments{
\item{...}{Vectors to coerce.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}
}
\value{
A vector with class given by \code{.ptype}, and length equal to the
sum of the \code{vec_size()} of the contents of \code{...}.

The vector will have names if the individual components have names
(inner names) or if the arguments are named (outer names). If both
inner and outer names are present, they are combined with a \code{.}.
}
\description{
Combine all arguments into a new vector of common type.
}
\section{Invariants}{

\itemize{
\item \code{vec_size(vec_c(x, y)) == vec_size(x) + vec_size(y)}
\item \code{vec_type(vec_c(x, y)) == vec_type_common(x, y)}.
}
}

\examples{
vec_c(FALSE, 1L, 1.5)
vec_c(FALSE, 1L, "x", .ptype = character())

# Date/times --------------------------
c(Sys.Date(), Sys.time())
c(Sys.time(), Sys.Date())

vec_c(Sys.Date(), Sys.time())
vec_c(Sys.time(), Sys.Date())

# Factors -----------------------------
c(factor("a"), factor("b"))
vec_c(factor("a"), factor("b"))
}
\seealso{
\code{\link[=vec_cbind]{vec_cbind()}}/\code{\link[=vec_rbind]{vec_rbind()}} for combining data frames by rows
or columns.
}
