% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{vec_proxy_compare}
\alias{vec_proxy_compare}
\title{Comparison proxy}
\usage{
vec_proxy_compare(x, ..., relax = FALSE)
}
\arguments{
\item{x}{A vector x.}

\item{...}{These dots are for future extensions and must be empty.}

\item{relax}{If \code{TRUE}, and \code{x} is otherwise non-comparable, will return
\code{vec_seq_along(x)}. This allows a data frame to be orderable, even if
one of its components is not. This is experimental and may change in the
future.}
}
\value{
A 1d atomic vector or a data frame.
}
\description{
Returns a proxy object (i.e. an atomic vector or data frame of atomic
vectors). For \link{vctr}s, this determins the behaviour of \code{\link[=order]{order()}} and
\code{\link[=sort]{sort()}} (via \code{\link[=xtfrm]{xtfrm()}}); \code{<}, \code{>}, \code{>=} and \code{<=} (via \code{\link[=vec_compare]{vec_compare()}});
and \code{\link[=min]{min()}}, \code{\link[=max]{max()}}, \code{\link[=median]{median()}}, and \code{\link[=quantile]{quantile()}}.
}
\details{
The default method assumes that all classes built on top of atomic
vectors or records are orderable. If your class is not, you will need
to provide a \code{vec_proxy_compare()} method that throws an error.
}
\keyword{internal}
