% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{vec_is_list}
\alias{vec_is_list}
\title{Is the object a list?}
\usage{
vec_is_list(x)
}
\arguments{
\item{x}{An object.}
}
\description{
\code{vec_is_list()} tests if \code{x} is considered a list in the vctrs sense. It
returns \code{TRUE} if:
\itemize{
\item \code{x} is a bare list with no class.
\item \code{x} is a list explicitly inheriting from \code{"list"}.
}
}
\details{
Notably, data frames and S3 record style classes like POSIXlt are not
considered lists.

If \code{x} inherits explicitly from \code{"list"}, it is also required that the
proxy returned by \code{\link[=vec_proxy]{vec_proxy()}} is a list. If it is not, an error is thrown.
}
\examples{
vec_is_list(list())
vec_is_list(list_of(1))

vec_is_list(data.frame())
}
