% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{vec_assert}
\alias{vec_assert}
\alias{vec_is}
\title{Assert an argument has known prototype and/or size}
\usage{
vec_assert(
  x,
  ptype = NULL,
  size = NULL,
  arg = caller_arg(x),
  call = caller_env()
)

vec_is(x, ptype = NULL, size = NULL)
}
\arguments{
\item{x}{A vector argument to check.}

\item{ptype}{Prototype to compare against. If the prototype has a
class, its \code{\link[=vec_ptype]{vec_ptype()}} is compared to that of \code{x} with
\code{identical()}. Otherwise, its \code{\link[=typeof]{typeof()}} is compared to that of
\code{x} with \code{==}.}

\item{size}{A single integer size against which to compare.}

\item{arg}{Name of argument being checked. This is used in error
messages. The label of the expression passed as \code{x} is taken as
default.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
\code{vec_is()} returns \code{TRUE} or \code{FALSE}. \code{vec_assert()} either
throws a typed error (see section on error types) or returns \code{x},
invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
\itemize{
\item \code{vec_is()} is a predicate that checks if its input is a vector that
conforms to a prototype and/or a size.
\item \code{vec_assert()} throws an error when the input is not a vector or
doesn't conform.
}
}
\section{Error types}{


\code{vec_is()} never throws.
\code{vec_assert()} throws the following errors:
\itemize{
\item If the input is not a vector, an error of class
\code{"vctrs_error_scalar_type"} is raised.
\item If the prototype doesn't match, an error of class
\code{"vctrs_error_assert_ptype"} is raised.
\item If the size doesn't match, an error of class
\code{"vctrs_error_assert_size"} is raised.
}

Both errors inherit from \code{"vctrs_error_assert"}.
}

\section{Lifecycle}{


Both \code{vec_is()} and \code{vec_assert()} are questioning because their \code{ptype}
arguments have semantics that are challenging to define clearly and are
rarely useful.
\itemize{
\item Use \code{\link[=obj_is_vector]{obj_is_vector()}} or \code{\link[=obj_check_vector]{obj_check_vector()}} for vector checks
\item Use \code{\link[=vec_check_size]{vec_check_size()}} for size checks
\item Use \code{\link[=vec_cast]{vec_cast()}}, \code{\link[=inherits]{inherits()}}, or simple type predicates like
\code{\link[rlang:type-predicates]{rlang::is_logical()}} for specific type checks
}
}

\section{Vectors and scalars}{


Informally, a vector is a collection that makes sense to use as column in a
data frame. The following rules define whether or not \code{x} is considered a
vector.

If no \code{\link[=vec_proxy]{vec_proxy()}} method has been registered, \code{x} is a vector if:
\itemize{
\item The \link[=typeof]{base type} of the object is atomic: \code{"logical"}, \code{"integer"},
\code{"double"}, \code{"complex"}, \code{"character"}, or \code{"raw"}.
\item \code{x} is a list, as defined by \code{\link[=obj_is_list]{obj_is_list()}}.
\item \code{x} is a \link{data.frame}.
}

If a \code{vec_proxy()} method has been registered, \code{x} is a vector if:
\itemize{
\item The proxy satisfies one of the above conditions.
\item The base type of the proxy is \code{"list"}, regardless of its class. S3 lists
are thus treated as scalars unless they implement a \code{vec_proxy()} method.
}

Otherwise an object is treated as scalar and cannot be used as a vector.
In particular:
\itemize{
\item \code{NULL} is not a vector.
\item S3 lists like \code{lm} objects are treated as scalars by default.
\item Objects of type \link{expression} are not treated as vectors.
}
}

\keyword{internal}
