% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-widgets.R
\name{shinybindings}
\alias{shinybindings}
\alias{toggleOutput}
\alias{renderToggle}
\alias{slideOutput}
\alias{slideTransition}
\alias{diffOutput}
\alias{diffTransition}
\title{Shiny bindings for graphical comparison widgets}
\usage{
toggleOutput(outputId, width = "100\%", height = "400px")

renderToggle(expr, env = parent.frame(), quoted = FALSE)

slideOutput(outputId, width = "100\%", height = "400px")

slideTransition(expr, env = parent.frame(), quoted = FALSE)

diffOutput(outputId, width = "100\%", height = "400px")

diffTransition(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{Must be a valid CSS unit (like \code{"100\\\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{An expression that generates a comparison widget.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using the Toggle, Slide and Diff
widgets within Shiny applications and interactive Rmd documents.
Used in \code{\link[=manage_cases]{manage_cases()}}.
}
