% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAbundance.R
\name{getAbundance}
\alias{getAbundance}
\title{Get abundance}
\usage{
getAbundance(
  collections,
  interval,
  species_list = NULL,
  trap_list = NULL,
  species_seperate = FALSE
)
}
\arguments{
\item{collections}{Collections data retrieved from getArthroCollections()}

\item{interval}{Calculation interval for abundance, accepts “collection_date”,“Biweek”,“Week”, and “Month.}

\item{species_list}{Species filter for calculating abundance. Species_display_name is the accepted notation.To see a list of species present in your data run unique(collections$species_display_name). If species is unspecified, the default NULL will return data for all species in data.}

\item{trap_list}{Trap filter for calculating abundance. Trap_acronym is the is the accepted notation. Run unique(collections$trap_acronym) to see trap types present in your data. If trap_list is unspecified, the default NULL will return data for all trap types.}

\item{species_seperate}{Should the species in species_list have abundance calculated separately? Setting to FALSE calculates the combined abundance. The same result can be performed by calculating on one species at the time.}
}
\value{
A dataframe of abundance values grouped by interval and filtered by parameters
}
\description{
Calculates abundance
}
\examples{
print(sample_collections)
getAbundance(sample_collections,
             interval = 'Week',
             species_list = list('Cx pipiens'),
             trap_list = list('GRVD', 'CO2'),
             species_seperate = FALSE)
}
