% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js-listener.R
\name{add-listeners}
\alias{add-listeners}
\alias{vw_add_signal_listener}
\alias{vw_add_data_listener}
\alias{vw_add_event_listener}
\title{Add JavaScript listeners}
\usage{
vw_add_signal_listener(x, name, handler_body)

vw_add_data_listener(x, name, handler_body)

vw_add_event_listener(x, event, handler_body)
}
\arguments{
\item{x}{vegawidget object to be monitored}

\item{name}{\code{character}, name of the signal or dataset to be monitored}

\item{handler_body}{\code{character} or \code{JS_EVAL}, text of the body of
the JavaScript handler-function to be called when the signal or dataset
changes, or the event fires}

\item{event}{\code{character}, name of the type of event to be monitored,
e.g. \code{"click"}}
}
\value{
modified copy of vegawidget object \code{x}
}
\description{
Listeners are how we get information out of a Vega chart and into the
JavaScript environment. To do this, we specify handler-functions to
run whenever a certain signal changes or an event fires.
}
\details{
The \code{handler_body} can be the text of the \emph{body} of a JavaScript function;
the arguments to this function will vary according to the type of listener
you are adding:
\itemize{
\item signal-handler and data-handler arguments: \code{name}, \code{value}
\item event-handler arguments: \code{event}, \code{item}
}

This package offers some functions to make it easier to build JavaScript
handler functions from R: \code{\link[=vw_handler_signal]{vw_handler_signal()}}, \code{\link[=vw_handler_data]{vw_handler_data()}},
and \code{\link[=vw_handler_event]{vw_handler_event()}}. You can pipe one of these functions to
\code{\link[=vw_handler_add_effect]{vw_handler_add_effect()}} to perform side-effects on the result.
}
\seealso{
\code{\link[=vw_handler_signal]{vw_handler_signal()}}, \code{\link[=vw_handler_data]{vw_handler_data()}}, \code{\link[=vw_handler_event]{vw_handler_event()}},
\code{\link[=vw_handler_add_effect]{vw_handler_add_effect()}}
vega-view:
\href{https://vega.github.io/vega/docs/api/view#view_addSignalListener}{addSignalListener()},
\href{https://vega.github.io/vega/docs/api/view/#view_addDataListener}{addDataListener()},
\href{https://vega.github.io/vega/docs/api/view#view_addEventListener}{addEventListener()}
}
