% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{s3_register}
\alias{s3_register}
\title{Register an s3 method}
\usage{
s3_register(generic, class, method = NULL)
}
\arguments{
\item{generic}{Name of the generic in the form \code{pkg::generic}.}

\item{class}{Name of the class}

\item{method}{Optionally, the implementation of the method. By default,
this will be found by looking for a function called \code{generic.class}
in the package environment.

Note that providing \code{method} can be dangerous if you use
devtools. When the namespace of the method is reloaded by
\code{devtools::load_all()}, the function will keep inheriting from
the old namespace. This might cause crashes because of dangling
\code{.Call()} pointers.}
}
\value{
Invisible \code{NULL}, called for side effects.
}
\description{
This is a reimplementation of \code{vctrs::s3_register()}, implemented here
to avoid having to take a dependency on vctrs.
}
\keyword{internal}
