% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\alias{clean_once}
\alias{clean,vegtable-method}
\title{Clean orphaned records in vegtable object}
\usage{
clean_once(object)

\S4method{clean}{vegtable}(object, times = 2, ...)
}
\arguments{
\item{object}{A \linkS4class{vegtable} object.}

\item{times}{Numeric value indicating how many times should be the cleaning
be repeated.}

\item{...}{Further arguments passed from or to other methods.}
}
\value{
A clean \linkS4class{vegtable} object.
}
\description{
Delete entries in slots \code{header} and \code{species} orphaned by manipulation of
slots.

Orphaned records generated by modifications in some slots may cause a loss
on the validity of \linkS4class{vegtable} objects.
This function should be applied to optimise the allocated size of a
\linkS4class{vegtable} object, as well. Since running cleaning only
once does not assure the deletion of all orphaned entries, it is recommended
to run it at least twice. This repetition of cleaning is controlled by the
argument \code{times}.
}
\examples{
## Create an invalid object
veg <- Kenya_veg
veg@header <- veg@header[1:10, ]

## Resolve invalidity
veg <- clean(veg)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
