% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_evap.R
\name{emis_evap}
\alias{emis_evap}
\title{Estimation of evaporative emissions}
\usage{
emis_evap(veh, name, size, fuel, aged, nd4, nd3, nd2, nd1, hs_nd4, hs_nd3,
  hs_nd2, hs_nd1, rl_nd4, rl_nd3, rl_nd2, rl_nd1, d_nd4, d_nd3, d_nd2, d_nd1)
}
\arguments{
\item{veh}{Total number of vehicles by age of use}

\item{name}{Character of type of vehicle}

\item{size}{Character of size of vehicle}

\item{fuel}{Character of fuel of vehicle}

\item{aged}{Age distribution vector. E.g.: 1:40}

\item{nd4}{Number of days with temperature between 20 and 35 celcius degrees}

\item{nd3}{Number of days with temperature between 10 and 25 celcius degrees}

\item{nd2}{Number of days with temperature between 0 and 15 celcius degrees}

\item{nd1}{Number of days with temperature between -5 and 10 celcius degrees}

\item{hs_nd4}{average daily hot-soak evaporative emissions for days with
temperature between 20 and 35 celcius degrees}

\item{hs_nd3}{average daily hot-soak evaporative emissions for days with
temperature between 10 and 25 celcius degrees}

\item{hs_nd2}{average daily hot-soak evaporative emissions for days with
temperature between 0 and 15 celcius degrees}

\item{hs_nd1}{average daily hot-soak evaporative emissions for days with
temperature between -5 and 10 celcius degrees}

\item{rl_nd4}{average daily running losses evaporative emissions for days with
temperature between 20 and 35 celcius degrees}

\item{rl_nd3}{average daily running losses evaporative emissions for days with
temperature between 10 and 25 celcius degrees}

\item{rl_nd2}{average daily running losses evaporative emissions for days with
temperature between 0 and 15 celcius degrees}

\item{rl_nd1}{average daily running losses evaporative emissions for days with
temperature between -5 and 10 celcius degrees}

\item{d_nd4}{average daily diurnal evaporative emissions for days with
temperature between 20 and 35 celcius degrees}

\item{d_nd3}{average daily diurnal evaporative emissions for days with
temperature between 10 and 25 celcius degrees}

\item{d_nd2}{average daily diurnal evaporative emissions for days with
temperature between 0 and 15 celcius degrees}

\item{d_nd1}{average daily diurnal evaporative emissions for days with
temperature between -5 and 10 celcius degrees}
}
\value{
dataframe of emission estimation in grams/days
}
\description{
Estimation of evaporative emissions from EMEP/EEA emisison guidelines
}
\examples{
\dontrun{
# Do not run
ef1 <- ef_evap(ef = "erhotc",v = "PC", cc = "<=1400", dt = "0_15", ca = "no")
dfe <- emis_evap(rep(50,3),"PC","<=1400","G", 1:3,
                     10,4,2,1,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3)
}
}
\references{
Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
