% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_evap.R
\name{emis_evap}
\alias{emis_evap}
\title{Estimation of evaporative emissions}
\usage{
emis_evap(
  veh,
  x,
  ed,
  hotfi,
  hotc,
  warmc,
  carb = 0,
  p,
  params,
  pro_month,
  verbose = FALSE
)
}
\arguments{
\item{veh}{Numeric or data.frame of Vehicles with untis 'veh'.}

\item{x}{Numeric which can be either, daily mileage by age of use
with units 'lkm', number of trips or number of proc. When it
has units 'lkm', all the emission factors must be in 'g/km'.
When ed is in g/day, x it is the number of days (without units).
When hotfi, hotc or warmc are in g/trip, x it is the number of trips (without units).
When hotfi, hotc or warmc are in g/proced, x it is the number of proced (without units).}

\item{ed}{average daily evaporative emisisons. If x has units 'lkm', the units
of ed must be 'g/km', other case, this are simply g/day (without units).}

\item{hotfi}{average hot running losses or soak evaporative factor
for vehicles with fuel injection and returnless fuel systems.
 If x has units 'lkm', the units of ed must be 'g/km',
 other case, this are simply g/trip or g/proced}

\item{hotc}{average running losses or soak evaporative factor for vehicles with
carburator or fuel return system
for vehicles with fuel injection and returnless fuel systems.
 If x has units 'lkm', the units of ed must be 'g/km',}

\item{warmc}{average cold and warm running losses or soak evaporative factor
for vehicles with carburator or fuel return system
for vehicles with fuel injection and returnless fuel systems.
 If x has units 'lkm', the units of ed must be 'g/km',}

\item{carb}{fraction of gasoline vehicles with carburator or fuel return system.}

\item{p}{Fraction of trips finished with hot engine}

\item{params}{Character; Add columns with information to returning data.frame}

\item{pro_month}{Numeric; montly profile to distribuite annual mileage in each month.}

\item{verbose}{Logical; To show more information}
}
\value{
numeric vector of emission estimation in grams
}
\description{
\code{\link{emis_evap}} estimates evaporative emissions from
EMEP/EEA emisison guidelines
}
\note{
When veh is a "Vehicles" data.frame, emission factors are evaluated till the
number of columns of veh. For instance, if the length of the emision factor is 20
but the number of columns of veh is 10, the 10 first emission factors are used.
}
\examples{
\dontrun{
(a <- Vehicles(1:10))
(lkm <- units::as_units(1:10, "km"))
(ef <- EmissionFactors(1:10))
(ev <- emis_evap(veh = a, x = lkm, hotfi = ef))
}
}
\references{
Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
\seealso{
\code{\link{ef_evap}}
}
