% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_age.R
\name{my_age}
\alias{my_age}
\title{Returns amount of vehicles at each age}
\usage{
my_age(
  x,
  y,
  agemax,
  name = "vehicle",
  k = 1,
  pro_street,
  net,
  verbose = FALSE,
  namerows
)
}
\arguments{
\item{x}{Numeric; vehicles by street (or spatial feature).}

\item{y}{Numeric or data.frame; when pro_street is not available, y must be
'numeric', else, a 'data.frame'. The names of the columns of this data.frame
must be the same of the elements of pro_street and each column must have a
profile of age of use of vehicle. When 'y' is 'numeric' the vehicles
has the same age distribution to all street. When 'y' is a data.frame,
the distribution by age of use varies the streets.}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{name}{Character; of vehicle assigned to columns of dataframe.}

\item{k}{Integer; multiplication factor. If its length is > 1, it must match the length of x}

\item{pro_street}{Character; each category of profile for each street.
The length of this character vector must be equal to the length of 'x'. The
names of the data.frame 'y' must be have the same content of 'pro_street'}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{verbose}{Logical; message with average age and total numer of vehicles.}

\item{namerows}{Any vector to be change row.names. For instance, name of
regions or streets.}
}
\value{
dataframe of age distrubution of vehicles.
}
\description{
\code{my_age} returns amount of vehicles at each age using a
numeric vector.
}
\note{
The functions age* produce distribution of the circulating fleet by age of use.
The order of using these functions is:

1. If you know the distribution of the vehicles by age of use , use:  \code{\link{my_age}}
2. If you know the sales of vehicles, or (the regis)*better) the registry of new vehicles,
use \code{\link{age}} to apply a survival function.
3. If you know the theoretical shape of the circulating fleet and you can use
\code{\link{age_ldv}}, \code{\link{age_hdv}} or \code{\link{age_moto}}. For instance,
you dont know the sales or registry of vehicles, but somehow you know
the shape of this curve.
4. You can use/merge/transform/adapt any of these functions.
}
\examples{
\dontrun{
data(net)
dpc <- c(seq(1,20,3), 20:10)
PC_E25_1400 <- my_age(x = net$ldv, y = dpc, name = "PC_E25_1400")
class(PC_E25_1400)
plot(PC_E25_1400)
PC_E25_1400sf <- my_age(x = net$ldv, y = dpc, name = "PC_E25_1400", net = net)
class(PC_E25_1400sf)
plot(PC_E25_1400sf)
PC_E25_1400nsf <- sf::st_set_geometry(PC_E25_1400sf, NULL)
class(PC_E25_1400nsf)
yy <- data.frame(a = 1:5, b = 5:1)    # perfiles por categoria de calle
pro_street <- c("a", "b", "a")         # categorias de cada calle
x <- c(100,5000, 3)                               # vehiculos
my_age(x = x, y =  yy, pro_street = pro_street)
}
}
