% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moves_rpdy_source.R
\name{moves_rpdy_sf}
\alias{moves_rpdy_sf}
\title{MOVES estimation of using rates per distance by model year}
\usage{
moves_rpdy_sf(
  veh,
  lkm,
  ef,
  speed_bin,
  profile,
  source_type_id = 21,
  vehicle = NULL,
  vehicle_type = NULL,
  fuel_subtype = NULL,
  path_all,
  verbose = FALSE
)
}
\arguments{
\item{veh}{"Vehicles" data-frame or list of "Vehicles" data-frame. Each data-frame
as number of columns matching the age distribution of that ype of vehicle.
The number of rows is equal to the number of streets link.}

\item{lkm}{Length of each link in miles}

\item{ef}{emission factors from EmissionRates_running exported from MOVES
filtered by sourceTypeID and fuelTypeID.}

\item{speed_bin}{Data.frame or vector of avgSpeedBinID as defined by MOVES.}

\item{profile}{numeric vector  of normalized traffic for the morning rush hour}

\item{source_type_id}{Number to identify type of vehicle as defined by MOVES.}

\item{vehicle}{Character, type of vehicle}

\item{vehicle_type}{Character, subtype of vehicle}

\item{fuel_subtype}{Character, subtype of vehicle}

\item{path_all}{Character to export whole estimation. It is not recommended since it
is usually too heavy.}

\item{verbose}{Logical; To show more information. Not implemented yet}
}
\value{
a list with emissions at each street and data.base aggregated by categories. See \code{link{emis_post}}
}
\description{
\code{\link{moves_rpdy_sf}} estimates running exhaust emissions
using MOVES emission factors.
}
\note{
`decoder` shows a decoder for MOVES
}
\examples{
{
data(decoder)
decoder
}
}
