% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R, R/lm.R, R/xgboost.R
\name{handler_startup}
\alias{handler_startup}
\alias{handler_startup.default}
\alias{handler_predict}
\alias{handler_predict.default}
\alias{handler_predict.lm}
\alias{handler_startup.xgb.Booster}
\alias{handler_predict.xgb.Booster}
\title{Model handler functions for API endpoint}
\usage{
handler_startup(vetiver_model)

\method{handler_startup}{default}(vetiver_model)

handler_predict(vetiver_model, ...)

\method{handler_predict}{default}(vetiver_model, ...)

\method{handler_predict}{lm}(vetiver_model, ...)

\method{handler_startup}{xgb.Booster}(vetiver_model)

\method{handler_predict}{xgb.Booster}(vetiver_model, ...)
}
\arguments{
\item{vetiver_model}{A deployable \code{\link[=vetiver_model]{vetiver_model()}} object}

\item{...}{Other arguments passed to \code{predict()}, such as prediction \code{type}}
}
\value{
A \code{handler_startup} function should return invisibly, while a
\code{handler_predict} function should return a function with the signature
\verb{function(req)}.
}
\description{
These are developer-facing functions, useful for supporting new model types.
Each model supported by \code{vetiver_model()} uses two handler functions
in \code{\link[=vetiver_pr_predict]{vetiver_pr_predict()}}:
\itemize{
\item The \code{handler_startup} function executes when the API starts. Use this
function for tasks like loading packages. A model can use the default
method here, which is \code{NULL} (to do nothing at startup).
\item The \code{handler_predict} function executes at each API call. Use this
function for calling \code{predict()} and any other tasks that must be executed
at each API call.
}
}
\details{
These are two generics that use the class of \code{vetiver_model$model}
for dispatch.
}
\examples{

cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
handler_startup(v)
handler_predict(v)

}
