% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor.R
\name{vetiver_plot_metrics}
\alias{vetiver_plot_metrics}
\title{Plot model metrics over time for monitoring}
\usage{
vetiver_plot_metrics(
  df_metrics,
  .index = .index,
  .estimate = .estimate,
  .metric = .metric,
  .n = .n
)
}
\arguments{
\item{df_metrics}{A tidy dataframe of metrics over time, such as created by}

\item{.index}{The variable in \code{df_metrics} containing the aggregated dates
or date-times (from \code{time_var} in \code{data}). Defaults to \code{.index}.}

\item{.estimate}{The variable in \code{df_metrics} containing the metric estimate.
Defaults to \code{.estimate}.}

\item{.metric}{The variable in \code{df_metrics} containing the metric type.
Defaults to \code{.metric}.}

\item{.n}{The variable in \code{df_metrics} containing the number of observations
used for estimating the metric.}
}
\value{
A \code{ggplot2} object.
}
\description{
These three functions can be used for model monitoring (such as in a
monitoring dashboard):
\itemize{
\item \code{\link[=vetiver_compute_metrics]{vetiver_compute_metrics()}} computes metrics (such as accuracy for a
classification model or RMSE for a regression model) at a chosen time
aggregation \code{period}
\item \code{\link[=vetiver_pin_metrics]{vetiver_pin_metrics()}} updates an existing pin storing model metrics
over time
\item \code{vetiver_plot_metrics()} creates a plot of metrics over time
}
}
\examples{
\dontshow{if (rlang::is_installed(c("dplyr", "parsnip", "modeldata", "arrow", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
library(parsnip)
data(Chicago, package = "modeldata")
Chicago <- Chicago \%>\% select(ridership, date, all_of(stations))
training_data <- Chicago \%>\% filter(date < "2009-01-01")
testing_data <- Chicago \%>\% filter(date >= "2009-01-01", date < "2011-01-01")
monitoring <- Chicago \%>\% filter(date >= "2011-01-01", date < "2012-12-31")
lm_fit <- linear_reg() \%>\% fit(ridership ~ ., data = training_data)

library(pins)
b <- board_temp()

## before starting monitoring, initiate the metrics and pin
## (for example, with the testing data):
original_metrics <-
    augment(lm_fit, new_data = testing_data) \%>\%
    vetiver_compute_metrics(date, "week", ridership, .pred, every = 4L)
pin_write(b, original_metrics, "lm_fit_metrics", type = "arrow")

## to continue monitoring with new data, compute metrics and update pin:
new_metrics <-
    augment(lm_fit, new_data = monitoring) \%>\%
    vetiver_compute_metrics(date, "week", ridership, .pred, every = 4L)
vetiver_pin_metrics(b, new_metrics, "lm_fit_metrics")

library(ggplot2)
vetiver_plot_metrics(new_metrics) +
    scale_size(range = c(2, 4))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=vetiver_compute_metrics]{vetiver_compute_metrics()}}, \code{\link[=vetiver_pin_metrics]{vetiver_pin_metrics()}}
}
