% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsconnect.R
\name{vetiver_create_rsconnect_bundle}
\alias{vetiver_create_rsconnect_bundle}
\title{Create an Posit Connect bundle for a vetiver model API}
\usage{
vetiver_create_rsconnect_bundle(
  board,
  name,
  version = NULL,
  predict_args = list(),
  filename = fs::file_temp(pattern = "bundle", ext = ".tar.gz")
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{predict_args}{A list of optional arguments passed to \code{\link[=vetiver_api]{vetiver_api()}}
such as the prediction \code{type}.}

\item{filename}{The path for the model API bundle to be created (can be
used as the argument to \code{connectapi::bundle_path()})}
}
\value{
The location of the model API bundle \code{filename}, invisibly.
}
\description{
Use \code{vetiver_create_rsconnect_bundle()} to create an Posit Connect model
API bundle for a \code{\link[=vetiver_model]{vetiver_model()}} that has been versioned and stored via
\code{\link[=vetiver_pin_write]{vetiver_pin_write()}}.
}
\details{
This function creates a deployable bundle. See
\href{https://docs.posit.co/connect/cookbook/deploying/}{Posit Connect docs}
for how to deploy this bundle, as well as the
\href{https://pkgs.rstudio.com/connectapi/}{connectapi} R package for how to
integrate with Connect's API from R.

The two functions \code{vetiver_create_rsconnect_bundle()} and
\code{\link[=vetiver_deploy_rsconnect]{vetiver_deploy_rsconnect()}} are alternatives to each other, providing
different strategies for deploying a vetiver model API to Posit Connect.
}
\examples{
\dontshow{if (rlang::is_installed("connectapi") && identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pins)
b <- board_temp(versioned = TRUE)
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

## when you pin to Posit Connect, your pin name will be typically be like:
## "user.name/cars_linear"
vetiver_create_rsconnect_bundle(
    b,
    "cars_linear",
    predict_args = list(debug = TRUE)
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=vetiver_write_plumber]{vetiver_write_plumber()}}, \code{\link[=vetiver_deploy_rsconnect]{vetiver_deploy_rsconnect()}}
}
