% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superlearner_functions.R
\name{sl_vglmer}
\alias{sl_vglmer}
\alias{SL.vglmer}
\alias{predict.SL.vglmer}
\alias{SL.glmer}
\alias{predict.SL.glmer}
\alias{add_formula_SL}
\title{SuperLearner with (Variational) Hierarchical Models}
\usage{
SL.vglmer(
  Y,
  X,
  newX,
  formula,
  family,
  id,
  obsWeights,
  control = vglmer_control()
)

\method{predict}{SL.vglmer}(object, newdata, allow_missing_levels = TRUE, ...)

SL.glmer(Y, X, newX, formula, family, id, obsWeights, control = NULL)

\method{predict}{SL.glmer}(object, newdata, allow.new.levels = TRUE, ...)

add_formula_SL(learner, env = parent.frame())
}
\arguments{
\item{Y}{From \code{SuperLearner}: The outcome in the training data set.}

\item{X}{From \code{SuperLearner}: The predictor variables in the training
data.}

\item{newX}{From \code{SuperLearner}: The predictor variables in validation
data.}

\item{formula}{The formula used for estimation.}

\item{family}{From \code{SuperLearner}: Currently allows \code{gaussian} or
\code{binomial}.}

\item{id}{From \code{SuperLearner}: Optional cluster identification variable.
See \code{SuperLearner} for more details.}

\item{obsWeights}{From \code{SuperLearner}: Weights for each observation. Not
permitted for \code{SL.vglmer}.}

\item{control}{Control object for estimating \code{vglmer} (e.g.,
\link{vglmer_control}) or \code{[g]lmer}.}

\item{object}{Used in \code{predict} for \code{SL.glmer} and
\code{SL.vglmer}. A model estimated using either \code{SL.vglmer} or
\code{SL.glmer}.}

\item{newdata}{Dataset to use for predictions.}

\item{allow_missing_levels}{Default (\code{TRUE}) allows prediction for
levels not observed in the estimation data; the value of \code{0} (with no
uncertainty) is used for the corresponding random effect. \bold{Note:} This
default differs from \code{predict.vglmer}.}

\item{...}{Not used; included to maintain compatibility with existing
methods.}

\item{allow.new.levels}{From \code{lme4}: Allow levels in prediction that are
not in the training data. Default is \code{TRUE} for \code{SuperLearner}.}

\item{learner}{Character name of model from \code{SuperLearner}. See
"Details" for how this is used.}

\item{env}{Environment to assign model. See "Details" for how this is used.}
}
\value{
The functions here return different types of output. \code{SL.vglmer}
  and \code{SL.glmer} return fitted models with the in-sample predictions as
  standard for \code{SuperLearner}. The \code{predict} methods return vectors
  of predicted values. \code{add_formula_SL} creates two objects in the
  environment (one for estimation \code{model_f} and one for prediction
  \code{predict.model_f}) used for \code{SuperLearner}.
}
\description{
These functions integrate \code{vglmer} (or \code{glmer}) into
\code{SuperLearner}. Most of the arguments are standard for
\code{SuperLearner} functions.
}
\details{
This documentation describes two types of function. 

  \bold{Estimating Hierarchical Models in SuperLearner}: Two methods for
  estimating hierarchical models are provided one for variational methods
  (\code{SL.vglmer}) and one for non-variational methods (\code{SL.glmer}).
  The accompanying prediction functions are also provided.

  \bold{Formula with SuperLearner}: The \code{vglmer} package provides a way
  to estimate models that require or use a formula with \code{SuperLearner}.
  This allows for a design to be passed that contains variables that are
  \emph{not} used in estimation. This can be used as follows (see
  "Examples"). One calls the function \code{add_formula_SL} around the quoted
  name of a \code{SuperLearner} model, e.g. \code{add_formula_SL(learner =
  "SL.knn")}. This creates a new model and predict function with the suffix
  \code{"_f"}. This \bold{requires} a formula to be provided for estimation.
  
  With this in hand, \code{"SL.knn_f"} can be passed to \code{SuperLearner} with the
  accompanying formula argument and thus one can compare models with
  different formula or design on the same ensemble. The \code{env} argument
  may need to be manually specified to ensure the created functions can be
  called by \code{SuperLearner}.
}
\examples{

set.seed(456)

if (requireNamespace('SuperLearner', quietly = TRUE)){
require(SuperLearner)
sim_data <- data.frame(
  x = rnorm(100),
  g = sample(letters, 100, replace = TRUE)
)
sim_data$y <- rbinom(nrow(sim_data), 
  1, plogis(runif(26)[match(sim_data$g, letters)]))
sim_data$g <- factor(sim_data$g)
sl_vglmer <- function(...){SL.vglmer(..., formula = y ~ x + (1 | g))}
SL.glm <- SuperLearner::SL.glm
add_formula_SL('SL.glm')
sl_glm_form <- function(...){SL.glm_f(..., formula = ~ x)}
\donttest{
   SuperLearner::SuperLearner(
     Y = sim_data$y, family = 'binomial',
     X = sim_data[, c('x', 'g')],
     cvControl = list(V = 2),
     SL.library = c('sl_vglmer', 'sl_glm_form')
   )
}
}
}
