% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SfArray-class}
\alias{SfArray-class}
\alias{SfArray}
\title{Array of '\code{\link[sf:sf]{sf}}'-derived class data}
\arguments{
\item{stack}{A \code{list} of \code{sf}-class objects.}

\item{index}{A \code{vector}, \code{matrix} or \code{array} type object. Includes either the indices of layers in the stack, or their names.}

\item{dim}{A \code{numeric} vector. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
An '\code{\link[via:SfArray-class]{SfArray}}'-class object.
}
\description{
Array class for easier navigation of vector spatial datasets
}
\details{
The class implements structures to organize entire '\code{\link[sf:sf]{sf}}' objects that share coordinate reference systesm. Subsetting rules were defined using the proxy object in the \code{@index} slot. See examples for implementations. The class is derived from the '\code{\link[via:XArray-class]{XArray}}' class.

The class has two slots:
\code{@stack}: A \code{list} object with multiple '\code{\link[sf:sf]{sf}}' class layers, the actual data.
\code{@index}: A proxy object that represents the organization of the layers.
}
\examples{
# example data
  library(sf) 
  data(paleocoastlines) 
  st <-paleocoastlines@stack
  ind <- 1:nlayers(st)
  dim(ind) <- c(3,2)
  dimnames(ind) <- list(age=c(0, 10, 20), c("margin", "coastlines"))
  sa<- SfArray(stack=st, index=ind)
  
}
