% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qtl.R
\name{plot_profile}
\alias{plot_profile}
\alias{only_plot_profile}
\alias{data_effects}
\alias{coord_radar}
\alias{plot_effects}
\alias{breeding_values}
\alias{calc_homologprob}
\alias{plot.mappoly.homoprob}
\alias{select_haplo}
\title{Logarithm of \emph{P}-value (LOP) profile plots. Modified version of QTLpoly function.}
\usage{
plot_profile(
  profile,
  qtl_info,
  selected_mks,
  pheno.col = NULL,
  lgs.id = NULL,
  by_range = TRUE,
  range.min = NULL,
  range.max = NULL,
  plot = TRUE,
  software = NULL
)

only_plot_profile(pl.in)

data_effects(
  qtl_info,
  effects,
  pheno.col = NULL,
  p1 = "P1",
  p2 = "P2",
  df.info = NULL,
  lgs = NULL,
  groups = NULL,
  position = NULL,
  software,
  design = c("bar", "circle", "digenic")
)

coord_radar(theta = "x", start = 0, direction = 1)

plot_effects(
  data_effects.obj,
  software,
  design = c("bar", "circle", "digenic")
)

breeding_values(qtl_info, probs, selected_mks, blups, beta.hat, pos)

calc_homologprob(probs, selected_mks, selected_lgs)

\method{plot}{mappoly.homoprob}(x, stack = FALSE, lg = NULL, ind = NULL, verbose = TRUE, ...)

select_haplo(input.haplo, probs, selected_mks, effects.data)
}
\arguments{
\item{x}{an object of class \code{mappoly.homoprob}}

\item{stack}{logical. If \code{TRUE}, probability profiles of all homologues
are stacked in the plot (default = FALSE)}

\item{lg}{indicates which linkage group should be plotted. If \code{NULL} 
(default), it plots the first linkage group. If 
\code{"all"}, it plots all linkage groups}

\item{ind}{indicates which individuals should be plotted. It can be the 
position of the individuals in the dataset or it's name. 
If \code{NULL} (default), the function plots the first 
individual}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}

\item{...}{unused arguments}

\item{use.plotly}{if \code{TRUE} (default), it uses plotly interactive graphic}
}
\description{
Plots profiled logarithm of score-based \emph{P}-values (LOP) from individual or combined traits.
}
\keyword{internal}
