% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_upload.R
\name{prepare_examples}
\alias{prepare_examples}
\alias{prepare_map_custom_files}
\alias{prepare_MAPpoly}
\alias{prepare_polymapR}
\alias{prepare_QTLpoly}
\alias{prepare_diaQTL}
\alias{prepare_polyqtlR}
\alias{prepare_qtl_custom_files}
\title{Upload example files}
\usage{
prepare_examples(example)

prepare_map_custom_files(dosages, phases, genetic_map)

prepare_MAPpoly(mappoly_list)

prepare_polymapR(polymapR.dataset, polymapR.map, input.type, ploidy)

prepare_QTLpoly(data, remim.mod, est.effects, fitted.mod)

prepare_diaQTL(scan1_list, scan1_summaries_list, fitQTL_list, BayesCI_list)

prepare_polyqtlR(polyqtlR_QTLscan_list, polyqtlR_qtl_info, polyqtlR_effects)

prepare_qtl_custom_files(
  selected_mks,
  qtl_info,
  blups,
  beta.hat,
  profile,
  effects,
  probs
)
}
\arguments{
\item{dosages}{TSV or TSV.GZ file with both parents dosage information.
It should contain four columns: 1) character vector with chromosomes ID; 
2) Character vector with markers ID; 3) Character vector with parent ID; 
4) numerical vector with dosage.}

\item{phases}{TSV or TSV.GZ file with phases information. It should contain:
1) Character vector with chromosome ID; 2) Character vector with marker ID;
3 to (ploidy number)*2 columns with each parents haplotypes.}

\item{genetic_map}{TSV or TSV.GZ file with the genetic map information}

\item{mappoly_list}{list with objects of class mappoly.map}

\item{data}{object of class "qtlpoly.data"}

\item{remim.mod}{object of class "qtlpoly.model" "qtlpoly.remim".}

\item{est.effects}{object of class "qtlpoly.effects"}

\item{fitted.mod}{object of class "qtlpoly.fitted"}
}
\description{
Upload example files

Converts map information in custom format files to viewmap object

Converts list of mappoly.map object into viewmap object

Converts polymapR ouputs to viewmap object

Converts QTLpoly outputs to viewqtl object

Converts diaQTL output to viewqtl object

Converts polyqtlR outputs to viewqtl object

Converts QTL information in custom files to viewqtl object
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
\keyword{internal}
