% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_map.R
\name{plot_map_list}
\alias{plot_map_list}
\title{Plot a genetic map - Adapted from MAPpoly}
\usage{
plot_map_list(viewmap, horiz = TRUE, col = "ggstyle", title = "Linkage group")
}
\arguments{
\item{viewmap}{object of class \code{viewmap}}

\item{horiz}{logical. If FALSE, the maps are plotted vertically with the first map to the left. 
If TRUE  (default), the maps are plotted horizontally with the first at the bottom}

\item{col}{a vector of colors for the bars or bar components (default = 'lightgrey')
\code{ggstyle} produces maps using the default \code{ggplot} color palette}

\item{title}{a title (string) for the maps (default = 'Linkage group')}
}
\value{
A \code{data.frame} object containing the name of the markers and their genetic position
}
\description{
This function plots a genetic linkage map(s)
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
\keyword{internal}
