% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_upload.R
\name{prepare_qtl_custom_files}
\alias{prepare_qtl_custom_files}
\title{Converts QTL information in custom files to viewqtl object}
\usage{
prepare_qtl_custom_files(
  selected_mks,
  qtl_info,
  blups,
  beta.hat,
  profile,
  effects,
  probs
)
}
\arguments{
\item{selected_mks}{data.frame with: LG - linkage group ID; mk - marker ID; pos - position in linkage map (cM)}

\item{qtl_info}{data.frame with: LG - linkage group ID; Pos - position in linkage map (cM); 
Pheno - phenotype ID; Pos_lower - lower position of confidence interval; 
Pos_upper - upper position of the confidence interval; Pval - QTL p-value; h2 - herdability}

\item{blups}{data.frame with: haplo - haplotype ID; pheno - phenotype ID; qtl - QTL ID; u.hat - QTL estimated BLUPs}

\item{beta.hat}{data.frame with: pheno - phenotype ID; beta.hat - estimated beta}

\item{profile}{data.frame with: pheno - phenotype ID; LOP - significance value for the QTL, in this case LOP (can be LOD or DIC depending of the software used)}

\item{effects}{data.frame with: pheno - phenotype ID; qtl.id - QTL ID; haplo - haplotype ID; effect - haplotype effect value}

\item{probs}{data.frame with first column (named `ind`) as individuals ID and next columns named with markers ID and containing the genotype probability at each marker}
}
\value{
object of class \code{viewqtl}
}
\description{
Converts QTL information in custom files to viewqtl object
}
\keyword{internal}
