% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_sphere.R
\name{generate_sphere}
\alias{generate_sphere}
\title{Generate a spherical point cloud}
\usage{
generate_sphere(angular_res = 1, r = 1, sph = FALSE)
}
\arguments{
\item{angular_res}{the angular resolution that sets the spacing between points.}

\item{r}{numeric. The sphere radius.}

\item{sph}{logical. If \code{TRUE} the spherical coordinates of the points
are returned, if \code{FALSE} the XYZ coordinates are returned.}
}
\value{
a data.table containing points coordinates.
}
\description{
Generate a spherical point cloud
}
\examples{
# generate a sphere
sph <- viewshed3d::generate_sphere()

# plot the sphere
rgl::plot3d(sph)

}
