% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spvim_se.R
\name{spvim_se}
\alias{spvim_se}
\title{Standard error estimate for SPVIM values}
\usage{
spvim_se(ics, idx = 1, gamma = 1, na_rm = FALSE)
}
\arguments{
\item{ics}{the influence function estimates based on the contributions 
from sampling observations and sampling subsets: a list of length two 
resulting from a call to \code{spvim_ics}.}

\item{idx}{the index of interest}

\item{gamma}{the proportion of the sample size used when sampling subsets}

\item{na_rm}{remove \code{NA}s?}
}
\value{
The standard error estimate for the desired SPVIM value
}
\description{
Compute standard error estimates based on the estimated influence function 
  for a SPVIM value of interest.
}
\details{
Since the processes for sampling observations and subsets are 
  independent, the variance for a given SPVIM estimator is simply the sum of
 the variances based on sampling observations and on sampling subsets.
}
\seealso{
\code{\link[vimp]{spvim_ics}} for how the influence functions are estimated.
}
