% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_violin_1x.R
\name{plot_violin_1x}
\alias{plot_violin_1x}
\title{One explanatory variable at a time violin plotter}
\usage{
plot_violin_1x(dat, response_variable_name, explanatory_variable_name,
               title="", xlab="", ylab="",
                   COLOURS=c("#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe"),
               BAR_COLOURS=c("#636363","#1c9099","#de2d26"),
               CI=95, XTICKS=TRUE, LOG=FALSE, BASE=10)
}
\arguments{
\item{dat}{dataframe where the response and explanatory variables including interaction terms if applicable are explicitly written into columns (output of the parse_formula() function) [mandatory]}

\item{response_variable_name}{string referring to the variable name of the response variable [mandatory]}

\item{explanatory_variable_name}{string referring to the variable name of the explanatory variable [mandatory]}

\item{title}{string corresponding to the explanatory term including additive and interaction terms in the formula [default=""]}

\item{xlab}{string specifying the x-axis label [default=""]}

\item{ylab}{string specifying the y-axis label [default=""]}

\item{COLOURS}{vector of colors of the violin plots which are repeated if the length is less than the number of explanatory factor levels [default=c("#e0f3db", "#ccebc5", "#a8ddb5", "#7bccc4", "#4eb3d3", "#2b8cbe")]}

\item{BAR_COLOURS}{vector of colors of standard deviation, standard error and 95 percent confidence interval error bars (error bar selection via leaving one of the three colors empty) [default=c("#636363", "#1c9099", "#de2d26")]}

\item{CI}{numeric referring to the percent confidence interval [default=95]}

\item{XTICKS}{logical referring to whether the explanatory variable is strictly categorical [default=TRUE]}

\item{LOG}{logical referring to whether to transform the explanatory variable into the logarithm scale [default=FALSE]}

\item{BASE}{numeric referring to the logarithm base to transform the explanatory variable with [default=1]}
}
\value{
Return 0 if successful
}
\description{
One explanatory variable at a time violin plotter
}
\examples{
x1 = rep(rep(rep(c(1:5), each=5), times=5), times=5)
x2 = rep(rep(letters[6:10], each=5*5), times=5)
x3 = rep(letters[11:15], each=5*5*5)
y = rep(1:5, each=5*5*5) + rnorm(rep(1:5, each=5), length(x1))
data = data.frame(x1, x2, x3, y)
formula = y ~ x1 + x2 + x3 + (x2:x3)
DF = parse_formula(formula=formula, data=data)
plot_violin_1x(dat=DF, response_variable_name="y", explanatory_variable_name="x3")

}
