% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/violinPoint.R
\name{vpPlot}
\alias{vpPlot}
\title{Plot data using offsets by quasirandom noise to generate a violin point plot}
\usage{
vpPlot(x = rep("Data", length(y)), y, xaxt = "y", offsetXArgs = NULL, ...)
}
\arguments{
\item{x}{a grouping factor for y (optional)}

\item{y}{vector of data points}

\item{xaxt}{if 'n' then no x axis is plotted}

\item{offsetXArgs}{a list with arguments for offsetX}

\item{...}{additional arguments to plot}
}
\value{
invisibly return the adjusted x positions of the points
}
\description{
Arranges data points using quasirandom noise (van der Corput sequence), pseudorandom noise or alternatively positioning extreme values within a band to the left and right to form beeswarm/one-dimensional scatter/strip chart style plots. That is a plot resembling a cross between a violin plot (showing the density distribution) and a scatter plot (showing the individual points) and so here we'll call it a violin point plot.
}
\examples{
dat<-list(
  'Mean=0'=rnorm(200),
  'Mean=1'=rnorm(50,1),
  'Bimodal'=c(rnorm(40,-2),rnorm(60,2)),
  'Gamma'=rgamma(50,1)
)
labs<-factor(rep(names(dat),sapply(dat,length)),levels=names(dat))
vpPlot(labs,unlist(dat))
}
\seealso{
\code{\link{offsetX}}
}

