% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateAccumulationRate.R
\name{simulateAccumulationRate}
\alias{simulateAccumulationRate}
\title{Simulates a virtual sediment accumulation rate.}
\usage{
simulateAccumulationRate(
  seed=50,
  time=1:1000,
  output.min=10,
  output.max=40,
  direction=1,
  plot=TRUE
  )
}
\arguments{
\item{seed}{integer, seed to be used by \code{\link{set.seed}} to configure the state of the pseudo-random number generator. It defines the shape of the curve.}

\item{time}{vector of time values (ideally the same used to generate the simulations). \strong{Important}: the \code{time} column goes from "left to right", meaning that oldest samples have the lowest values of age/time, and viceversa.}

\item{output.min}{numeric, in years per centimetre, minimum sediment accumulation rate (10 by default).}

\item{output.max}{numeric, in years per centimetre, maximum sediment accumulation rate (40 bu default).}

\item{direction}{integer, values 1 or -1, to invert the resulting accumulation rate.}

\item{plot}{boolean, plots output accumulation rate if \code{TRUE}.}
}
\value{
A dataframe like \code{\link{accumulationRate}}, with the following columns:
\itemize{
  \item \emph{time}: numeric, time or age of the given case.
  \item \emph{accumulation.rate}: numeric, in years per centimetre, simulated accumulation rate.
  \item \emph{grouping}: integer, grouping variable to aggregate together (with \code{\link{aggregateSimulation}}) samples deposited in the same centimetre according \emph{accumulation.rate}.
}
}
\description{
Generates a virtual sediment accumulation rate to be applied to the results of \code{\link{simulatePopulation}}.
}
\details{
The accumulation rate curve is generated through a random walk smoothed by a GAM model. The value of the \code{seed} argument changes the shape of the curve, but the user has no more control than trying different values to achieve a curve closer to the desired one. If \code{plot} is set to \code{TRUE}, the accumulation rate curve is printed on screen, but not exported to pdf.
}
\examples{

acc.rate <- simulateAccumulationRate(
 seed = 50,
 time = 1:1000,
 output.min = 10,
 output.max = 40,
 direction = 1,
 plot = TRUE
 )

str(acc.rate)

}
\seealso{
\code{\link{simulatePopulation}}, \code{\link{aggregateSimulation}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
