% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatEstimateValue.R
\name{formatEstimateValue}
\alias{formatEstimateValue}
\title{Formats the estimate_value column}
\usage{
formatEstimateValue(
  result,
  decimals = c(integer = 0, numeric = 2, percentage = 1, proportion = 3),
  decimalMark = ".",
  bigMark = ","
)
}
\arguments{
\item{result}{A \verb{<summarised_result>}.}

\item{decimals}{Number of decimals per estimate type (integer, numeric,
percentage, proportion), estimate name, or all estimate values (introduce the
number of decimals).}

\item{decimalMark}{Decimal separator mark.}

\item{bigMark}{Thousand and millions separator mark.}
}
\value{
A \verb{<summarised_result>}.
}
\description{
Formats the estimate_value column of \verb{<summarised_result>} object by editing
number of decimals, decimal and thousand/millions separator marks.
}
\examples{
result <- mockSummarisedResult()

result |> formatEstimateValue(decimals = 1)

result |> formatEstimateValue(decimals = c(integer = 0, numeric = 1))

result |>
  formatEstimateValue(decimals = c(numeric = 1, count = 0))
}
