% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_highlight.R
\name{add_highlight}
\alias{add_highlight}
\alias{add_highlight.ggsurvfit}
\title{Highlight a specific strata}
\usage{
add_highlight(gg, ...)

\method{add_highlight}{ggsurvfit}(gg = NULL, strata = NULL, bg_alpha = 0.2, ...)
}
\arguments{
\item{gg}{A ggplot created with visR}

\item{...}{other arguments passed on to the method}

\item{strata}{String representing the name and value of the strata to be highlighted as shown in the legend.}

\item{bg_alpha}{A numerical value between 0 and 1 that is used to decrease the opacity off all strata not chosen to be highlighted in \code{strata}. The other strata's existing alpha values are multiplied by \code{bg_alpha} to decrease their opacity, highlighting the target strata. This works on both \code{colour} and \code{fill} properties, as for example present after applying \code{visR::add_CI()}.}
}
\value{
The input \code{ggsurvfit} object with adjusted \code{alpha} values
}
\description{
S3 method for highlighting a specific strata by lowering the opacity of all other strata.
}
\examples{

adtte \%>\%
  visR::estimate_KM(strata = "SEX") \%>\%
  visR::visr() \%>\%
  visR::add_CI(alpha = 0.4) \%>\%
  visR::add_highlight(strata = "M", bg_alpha = 0.2)

strata <- c("Placebo", "Xanomeline Low Dose")

adtte \%>\%
  visR::estimate_KM(strata = "TRTP") \%>\%
  visR::visr() \%>\%
  visR::add_CI(alpha = 0.4) \%>\%
  visR::add_highlight(strata = strata, bg_alpha = 0.2)

}
