% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{ylimFromXlim}
\alias{ylimFromXlim}
\title{Adjust ylim to xlim}
\usage{
ylimFromXlim(xlim, centerY = 0, x_to_y = 16/9)
}
\arguments{
\item{xlim}{Numeric vector of length 2; the fixed lower and upper boundary
of the horizontal coordinate range}

\item{centerY}{The vertical coordinate which the output range is to be
centered around (default = 0)}

\item{x_to_y}{The desired ratio of the horizontal (x) to the vertical (y)
range. Default is 16/9, a display ratio frequently used for computer or
mobile screens}
}
\value{
A numeric vector of length 2; the lower and upper boundary of the
  resulting vertical coordinate range
}
\description{
This simple function is useful for adjusting x and y coordinate ranges
\code{xlim} and \code{ylim} in order to maintain a desired display ratio. The
former must be given, the latter will be adjusted.
}
\details{
For certain purposes, e.g. producing a graph that exactly matches a screen,
the x and y coordinates must be adjusted to match a given display ratio. If
the horizontal range, \code{xlim}, the desired ratio, \code{x_to_y} and the
desired center of the y-range, \code{centerY} are provided, this function
returns an adapted vertical range, that can be used as \code{ylim} in any
plot including \code{\link{phasePortrait}}.
}
\examples{
# Make a phase portrait of a Jacobi theta function that fully covers a
# plot with a display aspect ratio of 4/3.
# 10 inch wide window with 4/3 display ratio (x/y)
\donttest{
# x11(width = 10, height = 10 * 3/4) # Screen device commented out
                                     # due to CRAN test requirements.
                                     # Use it when trying this example
xlim <- c(-3, 3)
ylim <- ylimFromXlim(xlim, centerY = -0.3, x_to_y = 4/3)
op <- par(mar = c(0, 0, 0, 0), bg = "black") # Omit all plot margins
phasePortrait(jacobiTheta, moreArgs = list(tau = 1i/2 - 1/3),
  xlim = xlim, ylim = ylim, # Apply the coordinate ranges
  xaxs = "i", yaxs = "i",   # Allow for now room between plot and axes
  nCores = 1) # Max. two cores allowed on CRAN
              # not a limit for your own use
par(op)
  \dontshow{
  # R CMD check: make sure any open connections are closed afterward
  foreach::registerDoSEQ()
  doParallel::stopImplicitCluster()
  }
}


}
\seealso{
Other helpers: 
\code{\link{vector2String}()},
\code{\link{xlimFromYlim}()}
}
\concept{helpers}
