% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{summary2.VTSIMU}
\alias{summary2.VTSIMU}
\title{Summarize simulation results}
\usage{
\method{summary2}{VTSIMU}(x, ...)
}
\arguments{
\item{x}{A class \code{VTSIMU} list generated by \code{\link{vtSimu}}}

\item{...}{Reserved parameters}
}
\value{
A numeric array that shows 1: number of times each level is selected,
    2. total number of times any level is selected, 3. frequency each
    level is selected, 4. frequency any level is selected, 5. average number
    of DLT's and responders for each level, 6. average total number of DLT's
    and responders
}
\description{
Summarize simulation results to get the frequency of a dose level is identified
as the optimal dose level and the number of DLT's and responses
}
\examples{

rst.sce <- vtScenario(tox = c(0.05, 0.05, 0.08),
                      res = c(0.2, 0.3, 0.5),
                      rho = 1)
rst.simu  <- vtSimu(n.rep = 20, n.cors = 2, trueps = rst.sce,
                    size.cohort=3, size.level=12,
                    prob.mdl="NONPARA");
sum.simu <- summary2(rst.simu)


}
