% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistime-package.R, R/vistime.R
\docType{package}
\name{vistime}
\alias{vistime}
\alias{vistime-package}
\title{vistime}
\usage{
vistime(data, start = "start", end = "end", groups = "group",
  events = "event", colors = NULL)
}
\arguments{
\item{data}{data.frame that contains the data to be visualised}

\item{start}{(optional) the column name in \code{data} that contains start dates}

\item{end}{(optional) the column name in \code{data} that contains end dates}

\item{groups}{(optional) the column name in \code{data} to be used for grouping}

\item{events}{(optional) the column name in \code{data} that contains event names}

\item{colors}{(optional) the column name in \code{data} that contains colors for events}
}
\value{
\code{vistime} returns an object of class "\code{plotly}" and "\code{htmlwidget}".
}
\description{
Create interactive and offline timelines using the \code{plotly.js} framework.

Time data that is provided is distributed and grouped in a non-overlapping matter. It can then be edited via \code{plotly_build()} and e.g. be used in Shiny apps. The process works offline.
}
\examples{
# basic example
data(school)
vistime(school, events = "Language", groups = "Room")

# choose your own colors
dat <- data.frame(Position=c(rep("President", 3), rep("Vice", 3)),
                  Name = c("Washington", "Adams", "Jefferson", "Adams", "Jefferson", "Burr"),
                  start = rep(c("1789-03-29", "1797-02-03", "1801-02-03"), 2),
                  end = rep(c("1797-02-03", "1801-02-03", "1809-02-03"), 2),
                  colors = c('#cbb69d', '#603913', '#c69c6e'))

vistime(dat, events="Position", groups="Name")
}
\author{
Sandro Raabe \email{shosaco_nospam@hotmail.com}
}
\keyword{gantt}
\keyword{plotly}
\keyword{timeline}
\keyword{vistime}

