% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_annotations.R
\name{prepare_annotations}
\alias{prepare_annotations}
\title{prepare_annotations}
\usage{
prepare_annotations(df)
}
\arguments{
\item{df}{A rearranged and annotated VCF dataframe}
}
\value{
A dataframe containing each annotation on a separate column
}
\description{
Separates the SNPeff annotations found in an annotated and rearranged VCF dataframe (arranged using arrange_data)
}
\examples{
# Example 1: Shows the separation of the ANN column based on | delimiter.
test <- data.frame( ANN = c("A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P"))

# The ANN column will be split based on the strings in `snpeff_info()` and
# an additional "error" column.
snpeff_info()

# Split the SNPeff annotations in "ANN" column and save to dataframe `df`
df <- prepare_annotations(df)

# The one "ANN" column is split into 16 columns
dim(test)
dim(df)

}
