% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_local_importance.R
\name{plot.local_importance}
\alias{plot.local_importance}
\title{Plot Local Variable Importance measure}
\usage{
\method{plot}{local_importance}(
  x,
  ...,
  variables = NULL,
  color = NULL,
  type = NULL,
  title = "Local variable importance"
)
}
\arguments{
\item{x}{object returned from \code{local_variable_importance()} function}

\item{...}{other object returned from \code{local_variable_importance()} function that shall be plotted together}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}

\item{color}{a character. How to aggregated measure? Either  "_label_method_" or "_label_model_".}

\item{type}{a character. How variables shall be plotted? Either "bars" (default) or "lines".}

\item{title}{the plot's title, by default \code{'Local variable importance'}}
}
\value{
a ggplot2 object
}
\description{
Function plot.local_importance plots local importance measure based on Ceteris Paribus profiles.
}
\examples{

library("DALEX")
data(apartments)

library("randomForest")
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface +
                                    floor + no.rooms, data = apartments)

explainer_rf <- explain(apartments_rf_model, data = apartmentsTest[,2:5],
                        y = apartmentsTest$m2.price)

new_apartment <- data.frame(construction.year = 1998, surface = 88, floor = 2L, no.rooms = 3)

profiles <- predict_profile(explainer_rf, new_apartment)

library("vivo")
measure1 <- local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = TRUE, density = FALSE)

plot(measure1)

measure2 <- local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = TRUE, density = TRUE)
plot(measure1, measure2, color = "_label_method_", type = "lines")


}
