% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_int.R
\name{racusum_beta_arl_int}
\alias{racusum_beta_arl_int}
\title{Compute ARL of RA-CUSUM control charts assuming a beta distributed patient mix with using
 collocation methods.}
\usage{
racusum_beta_arl_int(h, N, RA, RQ, g0, g1, shape1, shape2, pw)
}
\arguments{
\item{h}{Double. \code{h} is the control limit (>\code{0}).}

\item{N}{Integer. Number of quadrature nodes, dimension of the resulting linear equation system
is equal to \code{N}.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.}

\item{g0}{Double. Estimated intercept coefficient from a binary logistic regression model.}

\item{g1}{Double. Estimated slope coefficient from a binary logistic regression model.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{pw}{Logical. If \code{FALSE} full collocation is applied. If \code{TRUE} a piece-wise
collocation method is used.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute ARL of RA-CUSUM control charts assuming a beta distributed patient mix with
using collocation methods.
}
\examples{
\dontrun{
library(vlad)
## full colocation
racusum_beta_arl_int(h=4.5, RA=2, RQ=1, shape1=1, shape2=6, g0=-3.6798, g1=0.0768*71, N=50,
 pw=FALSE)
## piece-wise colocation
racusum_beta_arl_int(h=4.5, RA=2, RQ=1, shape1=1, shape2=6, g0=-3.6798, g1=0.0768*71, N=49,
 pw=TRUE)
}
}
\author{
Philipp Wittenberg
}
