% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{search_delta}
\alias{search_delta}
\title{Search Box-Cox transformation parameter}
\usage{
search_delta(s, y, type = "ML", dmin = -2, dmax = 2)
}
\arguments{
\item{s}{Integer vector. Parsonnet Score values within a range of \code{0} to \code{100}
representing the preoperative patient risk.}

\item{y}{Double. Binary (\code{0/1}) outcome values of each operation.}

\item{type}{Character. If \code{type = "ML"} Maximum Likelihood used to search the Box-Cox
transformation parameter, \code{type = "Pearson"} uses a Pearson measure.}

\item{dmin}{Double. Minimum value for the grid search.}

\item{dmax}{Double. Maximum value for the grid search.}
}
\value{
Returns a single value for the Box-Cox transformation parameter.
}
\description{
Search Box-Cox transformation parameter.
}
\examples{
\dontrun{
## load data
data("cardiacsurgery", package = "spcadjust")

## preprocess data to 30 day mortality and subset data to
## phase I (In-control) and phase II (monitoring)
SALL <- cardiacsurgery \%>\% rename(s = Parsonnet) \%>\%
  mutate(y = ifelse(status == 1 & time <= 30, 1, 0),
         phase = factor(ifelse(date < 2*365, "I", "II")))

## subset phase I (In-control)
SI <- filter(SALL, phase == "I") \%>\% select(s, y)

## search delta
dML <- search_delta(SI$s, SI$y, type = "ML")
dQQ <- search_delta(SI$s, SI$y, type = "Pearson")

## show Log-likelihood (ell()) and Pearson measure (QQ()) for each delta
delta <- c(-2, -1, 0, dML, dQQ, 0.5, 1, 2)
r <- sapply(delta, function(i) rbind(i, ell(SI$s, SI$y, i), QQ(SI$s, SI$y, i)))
rownames(r) <- c("d", "l", "S")
t(r)
data.frame(t(r)) \%>\% filter(l == max(l) | S == min(S))
}
}
\references{
Knoth S, Wittenberg P and Gan FF (2019).
Risk-adjusted CUSUM charts under model error.
\emph{Statistics in Medicine}, \strong{38}(12), pp. 2206--2218..
}
\author{
Philipp Wittenberg
}
