% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significance_subset.R
\name{significance_subset}
\alias{significance_subset}
\title{Extract a subset population}
\usage{
significance_subset(polar, significance = NULL, output = "pvalues")
}
\arguments{
\item{polar}{A polar object including expression data from groups of
interest. Created by \code{\link{polar_coords}}.}

\item{significance}{Which significance factors to subset to. If NULL 
levels(syn_polar@polar$sig)[1] is selected.}

\item{output}{What object to return. Options are "pvalues", "expression", 
"polar_df" for subset data frames or "polar" for subset polar class object.}
}
\description{
Subsets data according to the significance groups.
}
\examples{
data(example_data)
syn_polar <- polar_coords(sampledata = syn_example_meta,
                          contrast = "Pathotype",
                          groups = NULL,
                          pvalues = syn_example_p,
                          expression = syn_example_rld,
                          p_col_suffix = "pvalue",
                          padj_col_suffix = "padj",
                          non_sig_name = "Not Significant",
                          multi_group_prefix = "LRT",
                          significance_cutoff = 0.01,
                          fc_col_suffix='log2FoldChange',
                          fc_cutoff = 0.3)

subset <- significance_subset(syn_polar, "Lymphoid+", "polar_df")
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://www.cell.com/cell-reports/fulltext/S2211-1247(19)31007-1}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
