% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rand_hpoly.R
\name{gen_rand_hpoly}
\alias{gen_rand_hpoly}
\title{Generator function for random H-polytopes}
\usage{
gen_rand_hpoly(dimension, nfacets, seed = NULL)
}
\arguments{
\item{dimension}{The dimension of the convex polytope.}

\item{nfacets}{The number of the facets.}

\item{seed}{Optional. A fixed seed for the generator.}
}
\value{
A polytope class representing a H-polytope.
}
\description{
This function generates a \eqn{d}-dimensional polytope in H-representation with \eqn{m} facets. We pick \eqn{m} random hyperplanes tangent on the \eqn{d}-dimensional unit hypersphere as facets.
}
\examples{
# generate a 10-dimensional polytope with 50 facets
P = gen_rand_hpoly(10, 50)
}
