% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_items_cor_items}
\alias{effect_metrics_items_cor_items}
\title{Output correlation coefficients for multiple items}
\usage{
effect_metrics_items_cor_items(
  data,
  cols,
  cross,
  method = "pearson",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{Tidyselect item variables (e.g. starts_with...).}

\item{method}{The output metrics, pearson = Pearson's R, spearman = Spearman's rho.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker table containing correlations.

If \code{method = "pearson"}:
\itemize{
\item \strong{R-squared}: Coefficient of determination.
\item \strong{n}: Number of cases the calculation is based on.
\item \strong{Pearson's r}: Correlation coefficient.
\item \strong{ci low / ci high}: Lower and upper bounds of the 95\% confidence interval.
\item \strong{df}: Degrees of freedom.
\item \strong{t}: t-statistic.
\item \strong{p}: p-value for the statistical test, indicating whether the correlation differs from zero.
\item \strong{stars}: Significance stars based on the p-value (*, **, ***).
}

If \code{method = "spearman"}:
\itemize{
\item \strong{Spearman's rho} is displayed instead of Pearson's r.
\item \strong{S-statistic} is used instead of the t-statistic.
}
}
\description{
The correlation is calculated using \code{stats::\link[stats:cor.test]{cor.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_items_cor_items(
  data,
  starts_with("cg_adoption_adv"),
  starts_with("use"),
  metric = TRUE
)

}
\keyword{internal}
