% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts2meanCluster.R
\name{ts2meanCluster}
\alias{ts2meanCluster}
\title{Timeseries to Mean Cluster}
\usage{
ts2meanCluster(image, mask)
}
\arguments{
\item{image}{Input image of type 'nifti'}

\item{mask}{Input mask of type 'nifti'. Must have different clusters labeled as integers.}
}
\description{
This function is able to output the mean voxel intensity over a cluster. 
Each column represents a cluster and the rows represent the t-dimension.
}
\examples{


image <- oro.nifti::nifti(img = array(1:320, dim =c(4,4,4,5)))
mask <- oro.nifti::nifti(img = array(0:15, dim = c(4,4,4,1)))
matrix <- ts2meanCluster(image, mask)
}
\keyword{internal}
