% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_intensities.R
\name{factor_intensities}
\alias{factor_intensities}
\title{Infer a matrix of non-negative intensities in NMF with offset/nmf-offset.}
\usage{
factor_intensities(
  C,
  X,
  fit.nmf = TRUE,
  fit.factor = FALSE,
  qp.exact = FALSE,
  n.iter = 200,
  qp.iter = 10,
  rel.error.cutoff = 1e-05,
  extrapolate = TRUE,
  extrapolate.const = TRUE,
  extrapolate.convex = FALSE,
  q.factor = 1,
  verbose = TRUE,
  n.cores = 1
)
}
\arguments{
\item{C}{Numeric matrices.}

\item{X}{Numeric matrices.}

\item{fit.nmf}{A boolean. Fit both intensities and spectrum of the offset residuals.}

\item{fit.factor}{A boolean. Fit only spectrum of the offset residuals (keep intensities constant across samples).}

\item{qp.exact}{A boolean. Estimate intensities using exact quadratic programming (qp.exact = TRUE) or inexact QP via gradient decent with extrapolation (qp.exact = FALSE).}

\item{n.iter}{An integer. Number of iterations.}

\item{qp.iter}{= 1e+1 An integer. Number of iterations of inexact QP.}

\item{rel.error.cutoff}{A numeric. Relative error cutoff between iterations to stop iterations.}

\item{extrapolate}{A boolean. Use Nesterov-like extrapolation at each iteration.}

\item{extrapolate.const}{A boolean. Use extrapolation scheme that adds a constant extrapolation q.factor (described below) at each iteration.}

\item{extrapolate.convex}{A boolean. Use Nesterov extrapolation scheme.}

\item{q.factor}{A numeric. Specification of a a constant extrapolation factor used in case of extrapolate.const = T.}

\item{verbose}{A boolean.  Print per-iteration information (by default TRUE).}

\item{n.cores}{An integer. Number of cores to use.}
}
\value{
Fitted matrix \code{D}.
}
\description{
\code{factor_intensities} estimates a non-negative matrix \code{D} that optimizes the objective function \eqn{F = ||X - C*D - offset||^2},
where offset is either column-specific offset or a "1-rank nmf term": product of row vector and column vector
}
