% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{weighted.sd}
\alias{weighted.sd}
\title{Weighted standard deviation}
\usage{
weighted.sd(x, w, na.rm = TRUE, type = "frequency")
}
\arguments{
\item{x}{A numeric vector.}

\item{w}{A vector of weights. Negative weights are not allowed.}

\item{na.rm}{Set to \code{TRUE} to remove indices with missing values in \code{x} or \code{w}.}

\item{type}{The type of weights to use. The default is \code{'frequency'}, which is applied when the weights represent frequencies. Also supports \code{'precision'} which is to be used when the weights represent precision.}
}
\description{
This is a basic weighted standard deviation function, mainly for internal use with \code{sumtable}. For a more fully-fledged weighted SD function, see \code{Hmisc::wtd.var}, although it uses a slightly differend degree-of-freedom correction.
}
\examples{
x <- c(1, 1, 2, 3, 4, 4, 4)
w <- c(4, 1, 3, 7, 0, 2, 5)
weighted.sd(x, w)

}
