% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{html_dependency_vue}
\alias{html_dependency_vue}
\title{Dependencies for Vue}
\usage{
html_dependency_vue(offline = TRUE, minified = TRUE)
}
\arguments{
\item{offline}{\code{logical} to use local file dependencies.  If \code{FALSE},
then the dependencies use cdn as its \code{src}.}

\item{minified}{\code{logical} to use minified (production) version.  Use
\code{minified = FALSE} for debugging or working with Vue devtools.}
}
\value{
\code{\link[htmltools]{htmlDependency}}
}
\description{
Dependencies for Vue
}
\examples{
if(interactive()){

library(vueR)
library(htmltools)

attachDependencies(
  tagList(
    tags$div(id="app","{{message}}"),
    tags$script(
    "
    var app = new Vue({
      el: '#app',
      data: {
        message: 'Hello Vue!'
      }
    });
    "
    )
  ),
  html_dependency_vue()
)
}
}
