% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_section_students.R
\name{get_section_students}
\alias{get_section_students}
\title{Retrieve Students in a Section}
\usage{
get_section_students(canvas, section_id, per_page = 100)
}
\arguments{
\item{canvas}{A list containing the Canvas API key and base URL, typically obtained through a \code{canvas_authenticate} function.}

\item{section_id}{The ID of the section for which to retrieve students.}

\item{per_page}{(Optional) The number of student records to retrieve per page of results. Defaults to 100.}
}
\value{
A data frame containing details of students enrolled in the specified section.
}
\description{
This function retrieves a list of students enrolled in a specific section of a course in Canvas LMS.
}
\examples{
\dontrun{
canvas <- list(base_url = "https://your_canvas_instance.instructure.com", api_key = "your_api_key")
section_id <- "67890"
students <- get_section_students(canvas, section_id)
print(students)
}

}
