% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/level.R
\name{level}
\alias{ela}
\alias{level}
\alias{math}
\title{Generate Random Vector of Levels}
\usage{
level(n, x = 1:4, prob = NULL, name = "Level")

math(n, x = 1:4, prob = c(0.29829, 0.33332, 0.22797, 0.14042),
  name = "Math")

ela(n, x = 1:4, prob = c(0.3161, 0.37257, 0.2233, 0.08803), name = "ELA")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of integer levels (1-4) elements.
}
\description{
\code{level} - Generate a random vector of integer levels (1-4).

\code{math} - Generate a random vector of integer mathematics levels (1-4)
similar to New York State grades 3-8 assessment results.

\code{math} - Generate a random vector of integer English language arts (ELA)
levels (1-4) similar to New York State grades 3-8 assessment results.
}
\details{
Distribution of levels (used in \code{prob}) were taken from New
York State' s 2014 assessment report: \url{http://www.p12.nysed.gov/irs/}

\tabular{lrr}{
  \bold{ Level}   \tab \bold{ELA}  \tab \bold{Math}\cr
  1 \tab 31.6\% \tab 29.8\%\cr
  2 \tab 37.3\% \tab 33.3\%\cr
  3 \tab 22.3\% \tab 22.8\%\cr
  4 \tab 8.8\%  \tab 14.0\%\cr
}
}
\examples{
level(10)
barplot(table(level(10000, prob = probs(4))))

math(10)
barplot(table(math(10000)))

ela(10)
barplot(table(ela(10000)))
}
\seealso{
Other variable.functions: \code{\link{age}};
  \code{\link{animal}}, \code{\link{pet}};
  \code{\link{answer}}; \code{\link{area}};
  \code{\link{birth}}, \code{\link{dob}};
  \code{\link{car}}; \code{\link{children}};
  \code{\link{coin}}; \code{\link{color}},
  \code{\link{primary}}; \code{\link{date_stamp}};
  \code{\link{death}}, \code{\link{died}};
  \code{\link{dice}}; \code{\link{dna}};
  \code{\link{dummy}}; \code{\link{education}};
  \code{\link{employment}}; \code{\link{eye}};
  \code{\link{gender_inclusive}},
  \code{\link{sex_inclusive}}; \code{\link{gender}},
  \code{\link{sex}}; \code{\link{gpa}},
  \code{\link{grade}}, \code{\link{grade_letter}};
  \code{\link{grade_level}}; \code{\link{group}};
  \code{\link{hair}}; \code{\link{height}},
  \code{\link{height_cm}}, \code{\link{height_in}};
  \code{\link{income}}; \code{\link{internet_browser}};
  \code{\link{iq}}; \code{\link{language}};
  \code{\link{likert}}, \code{\link{likert_5}},
  \code{\link{likert_7}}; \code{\link{lorem_ipsum}},
  \code{\link{paragraph}}; \code{\link{lower}},
  \code{\link{lower_factor}}, \code{\link{upper}},
  \code{\link{upper_factor}}; \code{\link{marital}};
  \code{\link{military}}; \code{\link{month}};
  \code{\link{name}}; \code{\link{normal}},
  \code{\link{normal_round}}; \code{\link{political}};
  \code{\link{race}}; \code{\link{religion}};
  \code{\link{sat}}; \code{\link{sentence}};
  \code{\link{smokes}}; \code{\link{speed}},
  \code{\link{speed_kph}}, \code{\link{speed_mph}};
  \code{\link{state}}; \code{\link{string}};
  \code{\link{valid}}; \code{\link{year}};
  \code{\link{zip_code}}
}
\keyword{level}

